//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.4

import wesual.Editor     1.0

import wesual.Ui         1.0
import wesual.Ui.Private 1.0

import wesual.data.Core  1.0


Item {
    id : logoPicker

    TypeListing {
        id : logoListing

        context : Editor.context
        type    : "asset:logo"
    }

//    DocumentModel {
//        id : logoModel
//        documents : logoListing.documents
//    }

    UiDropDownBase {
        id : dropdown

        labelDelegate : Rectangle {
            implicitWidth  : 108
            implicitHeight : 68

            Image {
                id : background
                anchors.fill    : parent
                anchors.margins : 6

                source : "qrc:/logomanagermodule/images/logo_background.png"
            }
            Image {
                anchors.fill : parent
                anchors.margins : 6

                fillMode : Image.PreserveAspectFit

                sourceSize.width  : 108
                sourceSize.height : 68

                source : dropdown.currentElement ?
                             dropdown.currentElement.file : ""

                asynchronous : true
            }
        }
        delegate : Item {
            implicitWidth  : 120
            implicitHeight : 80

            Image {
                id : background
                anchors.fill    : parent
                anchors.margins : 6

                source : "qrc:/logomanagermodule/images/logo_background.png"
            }
            Image {
                anchors.fill : parent
                anchors.margins : 6

                fillMode : Image.PreserveAspectFit

                sourceSize.width  : 108
                sourceSize.height : 68

                source : modelData.file

                asynchronous : true
            }
        }

        highlightDelegate : Rectangle {
            color : UiColors.getColor(UiColors.HoverGreen)
            anchors.fill : parent
        }
        model : logoListing.documents

        leftMargin : 7
        popupLeftMargin   : 1
        popupRightMargin  : 1
        popupTopMargin    : 1
        popupBottomMargin : 1
        popupHorizontalSpacing : -6
        popupVerticalSpacing   : -6
        popupColumns : 2
    }
}
